document.addEventListener('DOMContentLoaded', function() {
    const quotes = [
        "The quick brown fox jumps over the lazy dog.",
        "Lorem ipsum dolor sit amet, consectetur adipiscing elit.",
        "Programming is fun and challenging at the same time.",
        "Practice makes perfect.",
        "Coding is an essential skill in today's world."
    ];

    const quoteElement = document.getElementById('quote');
    const inputElement = document.getElementById('input');
    const startButton = document.getElementById('start-btn');
    const timeLeftElement = document.getElementById('time-left');
    const scoreElement = document.getElementById('score-value');

    let timer;
    let timeLeft;
    let score;
    let quote;

    function startGame() {
        score = 0;
        scoreElement.textContent = score;
        inputElement.value = '';
        inputElement.disabled = false;
        startButton.disabled = true;
        chooseQuote();
        renderQuote();
        inputElement.focus();
        startTimer();
    }

    function chooseQuote() {
        const randomIndex = Math.floor(Math.random() * quotes.length);
        quote = quotes[randomIndex];
    }

    function renderQuote() {
        quoteElement.textContent = quote;
    }

    function startTimer() {
        timeLeft = 60;
        updateTimeLeft();

        timer = setInterval(() => {
            timeLeft--;
            updateTimeLeft();

            if (timeLeft === 0) {
                endGame();
            }
        }, 1000);
    }

    function updateTimeLeft() {
        timeLeftElement.textContent = timeLeft;
    }

    function endGame() {
        clearInterval(timer);
        inputElement.disabled = true;
        startButton.disabled = false;
        alert(`Game Over! Your score is ${score}`);
    }

    inputElement.addEventListener('input', function() {
        const typedText = this.value.trim();
        const expectedText = quote.substring(0, typedText.length);

        if (typedText === expectedText) {
            if (typedText === quote) {
                score++;
                scoreElement.textContent = score;
                chooseQuote();
                renderQuote();
                this.value = '';
            }
        } else {
            this.value = expectedText;
        }
    });

    startButton.addEventListener('click', startGame);
});
